/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.hooks;

import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.ContextMenuManager;
import com.moulberry.axiom.KeyPressOverlay;
import com.moulberry.axiom.Toasts;
import com.moulberry.axiom.buildertools.BuilderToolManager;
import com.moulberry.axiom.configuration.Configuration;
import com.moulberry.axiom.displayentity.DisplayEntityManipulator;
import com.moulberry.axiom.marker.MarkerEntityManipulator;
import com.moulberry.axiom.render.BlockRenderCache;
import com.moulberry.axiom.screen.SwitchBuilderToolScreen;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_8251;
import org.joml.Matrix4f;

public class ScreenRenderHook {
    private static final class_2960 WIDGETS_LOCATION = new class_2960("textures/gui/widgets.png");
    private static final class_2960 TOOL_SWAPPER_LOCATION = new class_2960("axiom:gui/tool_swapper.png");

    public static void render(class_332 guiGraphics, int scaledWidth, int scaledHeight, float tickDelta) {
        if (!Axiom.isAxiomActive()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        BlockRenderCache.renderTick(guiGraphics);
        if (mc.field_1755 == null) {
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(0.0f, 0.0f, 500.0f);
            if (ContextMenuManager.getInstance().isActive()) {
                ContextMenuManager.getInstance().render(guiGraphics, scaledWidth, scaledHeight, tickDelta);
            } else if (BuilderToolManager.isToolSlotActive()) {
                BuilderToolManager.renderScreen(guiGraphics, scaledWidth, scaledHeight, tickDelta);
            }
            if (Configuration.rendering.showKeyHints) {
                List<Object> keyHints = List.of();
                if (BuilderToolManager.isToolSlotActive()) {
                    keyHints = BuilderToolManager.getKeyHints();
                } else if (DisplayEntityManipulator.hasActiveGizmo()) {
                    keyHints = DisplayEntityManipulator.getKeyHints();
                } else if (MarkerEntityManipulator.hasActiveGizmo()) {
                    keyHints = MarkerEntityManipulator.getKeyHints();
                }
                if (!keyHints.isEmpty()) {
                    class_327 font = class_310.method_1551().field_1772;
                    int[] widths = new int[keyHints.size()];
                    int maxWidth = 0;
                    for (int i = 0; i < keyHints.size(); ++i) {
                        String keyHint = (String)keyHints.get(i);
                        int width = font.method_1727(keyHint);
                        if (width > maxWidth) {
                            maxWidth = width;
                        }
                        widths[i] = width;
                    }
                    class_1041 window = class_310.method_1551().method_22683();
                    double otherScale = 4.0 / window.method_4495();
                    Objects.requireNonNull(font);
                    int hintHeight = 9 * keyHints.size();
                    int padding = 2;
                    Objects.requireNonNull(mc.field_1772);
                    int y = scaledHeight - (int)(9.0 * otherScale) - hintHeight - 30 - padding + 1;
                    if (Toasts.isRenderingToast()) {
                        y -= 43;
                    }
                    guiGraphics.method_25294(scaledWidth - maxWidth - padding * 2, y - padding, scaledWidth, y + hintHeight + padding - 1, -1728053248);
                    for (int i = 0; i < keyHints.size(); ++i) {
                        String keyHint = (String)keyHints.get(i);
                        int n = scaledWidth - widths[i] - padding;
                        Objects.requireNonNull(font);
                        guiGraphics.method_25303(font, keyHint, n, y + 9 * i, -1);
                    }
                }
            }
            guiGraphics.method_51448().method_22909();
        }
        Toasts.render(guiGraphics, scaledWidth, scaledHeight, tickDelta);
        guiGraphics.method_51452();
        if (Configuration.rendering.keypressOverlay) {
            ScreenRenderHook.renderKeypressOverlay(guiGraphics, scaledWidth, scaledHeight, mc);
        }
    }

    private static void renderKeypressOverlay(class_332 guiGraphics, int scaledWidth, int scaledHeight, class_310 mc) {
        List<KeyPressOverlay.StringWithOpacity> strings = KeyPressOverlay.getStrings();
        if (!strings.isEmpty()) {
            int width = 0;
            for (KeyPressOverlay.StringWithOpacity string : strings) {
                width += mc.field_1772.method_1727(string.string());
            }
            class_1041 window = class_310.method_1551().method_22683();
            Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)((double)window.method_4489() / 4.0), (float)((double)window.method_4506() / 4.0), 0.0f, 1000.0f, 21000.0f);
            Matrix4f oldProj = RenderSystem.getProjectionMatrix();
            class_8251 vertexSorting = RenderSystem.getVertexSorting();
            RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (class_8251)class_8251.field_43361);
            scaledWidth = window.method_4489() / 4;
            scaledHeight = window.method_4506() / 4;
            int hotbarRight = scaledWidth / 2 + (int)(30.0 * window.method_4495());
            int center = (hotbarRight + scaledWidth) / 2;
            int x = center - width / 2;
            if (x + width > scaledWidth) {
                x = scaledWidth - width;
            }
            Objects.requireNonNull(mc.field_1772);
            int y = scaledHeight - 9 - (int)(6.0 * window.method_4495());
            Objects.requireNonNull(mc.field_1772);
            guiGraphics.method_25294(x - 1, y - 1, x + width + 1, y + 9, -1728053248);
            for (KeyPressOverlay.StringWithOpacity string : strings) {
                x = guiGraphics.method_25303(mc.field_1772, string.string(), x, y, 0xFFFFFF | string.opacity() << 24) - 1;
            }
            guiGraphics.method_51452();
            RenderSystem.setProjectionMatrix((Matrix4f)oldProj, (class_8251)vertexSorting);
        }
    }

    public static void renderHotbar(class_332 guiGraphics, int scaledWidth, int scaledHeight, float tickDelta) {
        class_1297 class_12972 = class_310.method_1551().method_1560();
        if (!(class_12972 instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)class_12972;
        if (ContextMenuManager.getInstance().getActiveScreen() instanceof SwitchBuilderToolScreen) {
            return;
        }
        if (!BuilderToolManager.isToolSlotActive() && !Configuration.rendering.showBuilderToolSlot) {
            return;
        }
        int mid = scaledWidth / 2;
        class_1306 humanoidArm = player.method_6068();
        if (humanoidArm == class_1306.field_6182) {
            guiGraphics.method_25302(WIDGETS_LOCATION, mid - 91 - 29, scaledHeight - 23, 24, 22, 29, 24);
            if (BuilderToolManager.isToolSlotActive()) {
                guiGraphics.method_25302(WIDGETS_LOCATION, mid - 91 - 30, scaledHeight - 22 - 1, 0, 22, 24, 24);
            }
            guiGraphics.method_25302(TOOL_SWAPPER_LOCATION, mid - 91 - 26, scaledHeight - 19, 46 + 16 * BuilderToolManager.getToolSlotSelected(), 0, 16, 16);
        } else {
            guiGraphics.method_25302(WIDGETS_LOCATION, mid + 91, scaledHeight - 23, 53, 22, 29, 24);
            if (BuilderToolManager.isToolSlotActive()) {
                guiGraphics.method_25302(WIDGETS_LOCATION, mid + 91 + 6, scaledHeight - 22 - 1, 0, 22, 24, 24);
            }
            guiGraphics.method_25302(TOOL_SWAPPER_LOCATION, mid + 101, scaledHeight - 19, 46 + 16 * BuilderToolManager.getToolSlotSelected(), 0, 16, 16);
        }
    }
}

